<?php


/* ------------------------------------- */
/* alterego LATEST PROJECTS WIDGET */
/* ------------------------------------- */



class alteregoLatestProjects extends WP_Widget {

	function alteregoLatestProjects() {
		$widget_ops = array('classname' => 'alteregoLatestProjects', 'description' => 'A widget to display links to the latest projects.');
    	$this->WP_Widget('alteregoLatestProjects', 'alterego Latest Projects', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); 
		$portfolio_category = "";
		?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
		 <p><label for="<?php echo $this->get_field_id( 'description' ); ?>">Description:</label><br /><textarea class="widefat" style="height:150px;" id="<?php echo $this->get_field_id( 'description' ); ?>" name="<?php echo $this->get_field_name( 'description' ); ?>"><?php if( isset($instance['description']) ) echo $instance['description']; ?></textarea></p>
        
        <p><label for="<?php echo $this->get_field_id( 'projectcount' ); ?>">Number of Projects to show:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'projectcount' ); ?>" name="<?php echo $this->get_field_name( 'projectcount' ); ?>" value="<?php if( isset($instance['projectcount']) ) echo $instance['projectcount']; ?>" /></p> 

        <?php if ( !isset($instance['projectdisplay'])) $instance['projectdisplay']="image";

        ?>

		<p><label for="<?php echo $this->get_field_id( 'projectdisplay' ); ?>">Choose Portfolio:</label><br />
        <p>
		<?php 
                $portfolio_slugs = get_option("alterego_portfolio_slug");
                $portfolio_counter = 0;
                $portfolio_name = get_option("alterego_portfolio_name");
                $portfolio_list = "";
                foreach ( $portfolio_slugs as $slug ){
                    $checked="";
                    if(isset($instance['portfolio_category']) && $slug==$instance['portfolio_category']) $checked="selected";
                    $portfolio_list .= "<option value='$slug' $checked >".$portfolio_name[$portfolio_counter++]."</option>";
                }
        
        echo '<select name="'.$this->get_field_name( 'portfolio_category' ).'" class="widefat" >'.$portfolio_list.'
        </select></p>';
    }

	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$projectcount = $instance['projectcount'];
		$portfolio_category = $instance['portfolio_category'];
		$description = $instance['description'];
		echo $before_widget;
		
		$alterego_teaser_readmore = __('Read More', 'alterego');

	   	if ( $title ) echo $before_title . $title . $after_title;
		
		$columndiv = "";

		$pcat = "category_".$portfolio_category;
		$args=array(
			'post_type' => $portfolio_category,
			'posts_per_page' => $projectcount
		);

		$rownumber = 2;
		global $wp_query;
		$temp = $wp_query; 
		$wp_query = null;
		$wp_query = new WP_Query();
		$wp_query->query($args);
		$terms = get_terms($pcat);

		$unique = uniqid();
		$poplist = get_posts( $args );
		$element_count=1;
		$return_list = '			
					<div class="tp_teaser hoverable one_per_page">
				<div class="tp_teaser_navigation rightfloat">
											<div class="tp_teaser_close hidden"></div>
											<div class="tp_teaser_left notinuse"></div>
											<div class="tp_teaser_right"></div>
											<div class="clear"></div>
										</div>'	;
		if($description!="") $return_list .= "<p>$description</p>";
		$return_list .= '	<div class="divide5 footerdivider_null"></div>										
										<div class="tp_teaser_rotator">													
											<ul>';
		foreach ($poplist as $poppost) :  
				setup_postdata($poppost);
           	    
           	    $terms = get_the_terms($poppost->ID,$pcat);

           	    $tax_cats = "";
				foreach ($terms as $tax_term) {
					$tax_cats.= ', <a href="'.esc_attr(get_term_link($tax_term, $pcat)).'">'.$tax_term->name.'</a>';
				}
				$entrycategory = substr($tax_cats, 2);

				//$repl = strtolower((preg_replace('/\s+/', '-', $first_category)));
				$base = home_url();

				if(strlen($poppost->post_title)>18)
					$posttitle = substr($poppost->post_title, 0, 18)."...";
				else
					$posttitle = $poppost->post_title;

				if($element_count % $rownumber == 0){$lastelement = " ";}
				else $lastelement = "";
                

				
                $blogimageurl = wp_get_attachment_url( get_post_thumbnail_id($poppost->ID) ); 
	            	if ($blogimageurl != "") {
	            		$return_list .= '<li>
											<div class="insidecontainer">
												<div class="tp_teaser_imgholder">
														<div class="fullcover"></div>
														<div class="viewproject pmore"><a data-href="true" href="'.get_permalink($poppost->ID).'">View Project</a></div>
														<img src="'.aq_resize($blogimageurl,225,160,true).'">
														<div class="thegoldholder"></div>														
												</div>
												<div class="insidecontainer_grey">
													<div class="leftfloat subinfo">'.$entrycategory.'</div>
													<div class="rightfloat fh-category"></div>
													<div class="clear"></div>
												</div>
												<div class="teaser_divider"></div>
												<h5 class="teaser_title"><a href="'.get_permalink($poppost->ID).'">'.$posttitle.'</a></h5>
												<div class="divide15"></div>
											</div>
										</li>';
					}
				$element_count++;
      endforeach;
      $return_list .= "</ul></div></div>";
      $wp_query = null; 
	  $wp_query = $temp;
	  wp_reset_query();
	  echo $return_list;
	echo $after_widget;




	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['projectcount'] = $new_instance['projectcount'];
		$instance['description'] = $new_instance['description'];
		$instance['portfolio_category'] = $new_instance['portfolio_category'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoLatestProjects");') );



/* ------------------------------------- */
/* alterego CUSTOM CATEGORIES WIDGET */
/* ------------------------------------- */
$template_uri_widgets = get_template_directory_uri();

class alteregoCategories extends WP_Widget
{
  function alteregoCategories()
  {
    $widget_ops = array('classname' => 'alteregoCategories', 'description' => 'Displays a list of Blog Categories' );
    $this->WP_Widget('alteregoCategories', 'alterego Categories', $widget_ops);
  }
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
?>
  <p><label for="<?php echo $this->get_field_id('title'); ?>">Title: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></label></p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    return $instance;
  }
 
  function widget($args, $instance)
  {
    extract($args, EXTR_SKIP);
 
    echo $before_widget;
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
 
    if (!empty($title))
      echo $before_title . $title . $after_title;;
 
	echo '<div class="widget_link_list"><ul class="blogcategory">';
	$cats = get_categories();
	foreach ($cats as $cat) {
		$my_query = new WP_Query('category_name='.$cat->name.'&posts_per_page=1'); 
 		while ($my_query->have_posts()) : $my_query->the_post();
      		 $blogimageurl = wp_get_attachment_url( get_post_thumbnail_id() ); 
        endwhile; 
		echo '<li ><a href="'.get_category_link( $cat->term_id ).'">'.$cat->name.' - <span class="highlight">('.$cat->count.')</span></a></li>';
	}
    echo '</ul></div>';
 
    echo $after_widget;
  }
 
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoCategories");') );


/* ------------------------------------- */
/* alterego CUSTOM ARCHIVES WIDGET */
/* ------------------------------------- */


class alteregoArchives extends WP_Widget
{
  function alteregoArchives()
  {
    $widget_ops = array('classname' => 'alteregoArchives', 'description' => 'Displays the Blog Archives' );
    $this->WP_Widget('alteregoArchives', 'alterego Archives', $widget_ops);
  }
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
?>
  <p><label for="<?php echo $this->get_field_id('title'); ?>">Title: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></label></p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    return $instance;
  }
 
  function widget($args, $instance)
  {
    extract($args, EXTR_SKIP);
 
    echo $before_widget;
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
 
    if (!empty($title))
    echo $before_title . $title . $after_title;

	echo '<div class="blogcategories"><ul class="blogcategory">';
	wp_get_archives(apply_filters('widget_archives_dropdown_args', array('type' => 'monthly', 'format' => 'html', 'before' => '<span></span>')));
    echo '</ul></div><div style="clear:both;"></div>';
 
    echo $after_widget;
  }
 
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoArchives");') );


/* ------------------------------------- */
/* alterego MINI GALLERY SIDEBAR WIDGET */
/* ------------------------------------- */


class alteregoMinigallery extends WP_Widget {

	function alteregoMinigallery() {
		$widget_ops = array('classname' => 'alteregoMinigallery', 'description' => 'A sidebar mini gallery. Please enter the links to the large images. Thumbs are generated automatically.');
    	$this->WP_Widget('alteregoMinigallery', 'alterego Mini Gallery', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>

		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
		
        <p><label for="<?php echo $this->get_field_id( 'images' ); ?>">Image Url's (Separate with line breaks)</label><br /><textarea class="widefat" style="height:150px;" id="<?php echo $this->get_field_id( 'images' ); ?>" name="<?php echo $this->get_field_name( 'images' ); ?>"><?php if( isset($instance['images']) ) echo $instance['images']; ?></textarea></p> 
        
        <p><label for="<?php echo $this->get_field_id( 'titles' ); ?>">Image titles(Separate with line breaks)</label><br /><textarea class="widefat" style="height:150px;" id="<?php echo $this->get_field_id( 'titles' ); ?>" name="<?php echo $this->get_field_name( 'titles' ); ?>"><?php if( isset($instance['titles']) ) echo $instance['titles']; ?></textarea></p> 
        
        
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$imagearr = $instance['images'];
		//$descriptionarr = $instance['descriptions'];
		$titlearr = $instance['titles'];

		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;
		$imagelinks = explode("\n", $imagearr);
		//$descs = explode("\n", $descriptionarr);
		$titles = explode("\n", $titlearr);
		$ivar = 0;
		$unique = "gallery-".rand(1234, 4321);
		echo '<div style="position:relative;">';
			$element_count = 1;
			$lastelement="";
			$maxitem=count($imagelinks);
			$aktitem=0;
						
			foreach($imagelinks as $imagelink):
				$aktitem++;
				if(isset($descs[$ivar])){
					$currentdesc = $descs[$ivar];
				}else{
					$currentdesc = "";
				}
				
				if(isset($titles[$ivar])){
					$currenttitle = $titles[$ivar];
				}else{
					$currenttitle = "";
				}
				
				if($element_count % 3 == 0){$lastelement = " lastcolumn";}
				else $lastelement = "";

				
				$imagelink_small = aq_resize(trim($imagelink),80,80,true);

				
				$columndiv = "one_third ";
				if($imagelink!=""){	
					echo '<div class=" flickrwidget '.$columndiv.$lastelement.' ">
								<div class="mediaholder flickrwidget">
									<div class="fullcover"></div>
									<div class="viewproject"><a href="'.$imagelink.'" rel="prettyPhoto['.$unique.']" title="'.$currenttitle.'"><div class="plusicon"></div></a></div>
									<a  href="'.$imagelink.'" rel="prettyPhoto['.$unique.']" title="'.$currenttitle.'"><img src="'.$imagelink_small.'">	</a>										
								</div>
							</div>';
					if($element_count % 3 == 0 && $aktitem<$maxitem){echo '<div class="clear"></div><div class="divide15 minig_dividers"></div>';}
				}
				$element_count++;
				$ivar++;
			endforeach;
		echo '</div>';
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['images'] = $new_instance['images'];
		$instance['titles'] = $new_instance['titles'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoMinigallery");') );


/* ------------------------------------- */
/* alterego SIDEBAR VIMEO WIDGET */
/* ------------------------------------- */


class alteregoSidebarvimeo extends WP_Widget {

	function alteregoSidebarvimeo() {
		$widget_ops = array('classname' => 'alteregoSidebarvimeo', 'description' => 'Display a vimeo video in the sidebar.');
    	$this->WP_Widget('alteregoSidebarvimeo', 'alterego Video Sidebar Vimeo', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'videoid' ); ?>">Vimeo Video ID:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videoid' ); ?>" name="<?php echo $this->get_field_name( 'videoid' ); ?>" value="<?php if( isset($instance['videoid']) ) echo $instance['videoid']; ?>" /></p> 
        <p><label for="<?php echo $this->get_field_id( 'videowidth' ); ?>">Video Width(given by Vimeo):</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videowidth' ); ?>" name="<?php echo $this->get_field_name( 'videowidth' ); ?>" value="<?php if( isset($instance['videowidth']) ) echo $instance['videowidth']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'videoheight' ); ?>">Video Height:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videoheight' ); ?>" name="<?php echo $this->get_field_name( 'videoheight' ); ?>" value="<?php if( isset($instance['videoheight']) ) echo $instance['videoheight']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'videodesc' ); ?>">Video Description:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videodesc' ); ?>" name="<?php echo $this->get_field_name( 'videodesc' ); ?>" value="<?php if( isset($instance['videodesc']) ) echo $instance['videodesc']; ?>" /></p> 
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$vimeoid = $instance['videoid'];
		$vimeowidth = $instance['videowidth'];
		$vimeoheight = $instance['videoheight'];
		if(isset($instance['videodesc']))
			$vimeodesc = $instance['videodesc'];
		else
			$vimeodesc="";
		if($vimeodesc!="") $vimeodesc = '<p class="video_info">'.$vimeodesc.'</p>';

		$post_top_width = 225;
		$video_width = $instance['videowidth'];
		$video_height = $instance['videoheight'];
		
		if ( function_exists( 'get_option_tree') ) {
			$main_color = str_replace("#","",get_option_tree( 'alterego_main_color_1' ));
		}
		//if($video_width>$post_top_width)
		/*	$video_width_ratio = $video_width/$post_top_width;
		else*/
			$video_width_ratio = $post_top_width/$video_width;

		$video_height = $video_height*$video_width_ratio;
		$video_width = $post_top_width;

		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;

		echo '			<div class="mediaholder scalevid">
								<iframe src="http://player.vimeo.com/video/'.$vimeoid.'?title=0&byline=0&portrait=0&autohide=1&color='.$main_color.'" width="'.$video_width.'" height="'.$video_height.'"></iframe>
					</div>'.$vimeodesc.'<script>jQuery("document").ready(function(){jQuery(".scalevid").fitVids();});</script>';
	
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['videoid'] = $new_instance['videoid'];
		$instance['videowidth'] = $new_instance['videowidth'];
		$instance['videoheight'] = $new_instance['videoheight'];
		$instance['videodesc'] = $new_instance['videodesc'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoSidebarvimeo");') );


/* ------------------------------------- */
/* alterego SIDEBAR youtube WIDGET */
/* ------------------------------------- */


class alteregoSidebaryoutube extends WP_Widget {

	function alteregoSidebaryoutube() {
		$widget_ops = array('classname' => 'alteregoSidebaryoutube', 'description' => 'Display a youtube video in the sidebar.');
    	$this->WP_Widget('alteregoSidebaryoutube', 'alterego Video Sidebar youtube', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'videoid' ); ?>">youtube Video ID:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videoid' ); ?>" name="<?php echo $this->get_field_name( 'videoid' ); ?>" value="<?php if( isset($instance['videoid']) ) echo $instance['videoid']; ?>" /></p> 
        <p><label for="<?php echo $this->get_field_id( 'videowidth' ); ?>">Video Width(given by youtube):</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videowidth' ); ?>" name="<?php echo $this->get_field_name( 'videowidth' ); ?>" value="<?php if( isset($instance['videowidth']) ) echo $instance['videowidth']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'videoheight' ); ?>">Video Height:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videoheight' ); ?>" name="<?php echo $this->get_field_name( 'videoheight' ); ?>" value="<?php if( isset($instance['videoheight']) ) echo $instance['videoheight']; ?>" /></p>
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$youtubeid = $instance['videoid'];
		$youtubewidth = $instance['videowidth'];
		$youtubeheight = $instance['videoheight'];

		$post_top_width = 225;
		$video_width = $instance['videowidth'];
		$video_height = $instance['videoheight'];

		//if($video_width>$post_top_width)
		/*	$video_width_ratio = $video_width/$post_top_width;
		else*/
			$video_width_ratio = $post_top_width/$video_width;

		$video_height = $video_height*$video_width_ratio;
		$video_width = $post_top_width;

		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;

		echo '			<div class="divide5"></div>
							<div class="mediaholder scalevid">
								<iframe src="http://www.youtube.com/embed/'.$youtubeid.'?hd=1&wmode=opaque&autohide=1&showinfo=0" width="'.$video_width.'" height="'.$video_height.'" frameborder="0"></iframe>
							</div>';
	
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['videoid'] = $new_instance['videoid'];
		$instance['videowidth'] = $new_instance['videowidth'];
		$instance['videoheight'] = $new_instance['videoheight'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoSidebaryoutube");') );

/* ------------------------------------- */
/* alterego SIDEBAR flv WIDGET */
/* ------------------------------------- */


class alteregoSidebarflv extends WP_Widget {

	function alteregoSidebarflv() {
		$widget_ops = array('classname' => 'alteregoSidebarflv', 'description' => 'Display a flv video in the sidebar.');
    	$this->WP_Widget('alteregoSidebarflv', 'alterego Video Sidebar FLV', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'videoid' ); ?>">flv Video URL:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videoid' ); ?>" name="<?php echo $this->get_field_name( 'videoid' ); ?>" value="<?php if( isset($instance['videoid']) ) echo $instance['videoid']; ?>" /></p> 
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );
		global $template_uri_widgets;
		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$flvid = $instance['videoid'];
		$uniq = uniqid("flv_sid_");
		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;

   		echo '<div class="video_top"></div><div class="bordered video-container_master" style="max-width:100%;height:auto;">
							<div class="video-wrapper">
								<div class="video-container"><a class="bordered" href="'.$flvid.'" style="display:block;width=202px;height:115px;"   id="'.$uniq.'"> </a> 
		</div></div></div>
			<!-- this will install flowplayer inside previous A- tag. -->
			<script>
				flowplayer("'.$uniq.'", "'.$template_uri_widgets.'/js/flowplayer_plugins/flowplayer-3.2.7.swf",{clip : {			autoPlay: false,
				       autoBuffering: true
				   },plugins: {
					controls: null
				}});
			</script>';
	
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['videoid'] = $new_instance['videoid'];
		return $instance;
	}
}
//add_action( 'widgets_init', create_function('', 'return register_widget("alteregoSidebarflv");') );

/* ------------------------------------- */
/* alterego SIDEBAR html5 WIDGET */
/* ------------------------------------- */


class alteregoSidebarhtml5 extends WP_Widget {

	function alteregoSidebarhtml5() {
		$widget_ops = array('classname' => 'alteregoSidebarhtml5', 'description' => 'Display a HTML5 video in the sidebar (see www.mediaelementjs.com for Browser and Device Support)');
    	$this->WP_Widget('alteregoSidebarhtml5', 'alterego Video Sidebar HTML5', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'videomp4' ); ?>">MP4/M4V File URL:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'videomp4' ); ?>" name="<?php echo $this->get_field_name( 'videomp4' ); ?>" value="<?php if( isset($instance['videomp4']) ) echo $instance['videomp4']; ?>" /></p> 
        <p><label for="<?php echo $this->get_field_id( 'preview' ); ?>">Preview Image URL:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'preview' ); ?>" name="<?php echo $this->get_field_name( 'preview' ); ?>" value="<?php if( isset($instance['preview']) ) echo $instance['preview']; ?>" /></p>
        
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );
		global $template_uri_widgets;
		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$videomp4 = $instance['videomp4'];
		$videowebm = $instance['videowebm'];
		$preview = $instance['preview'];
		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;

	   	echo '';
   		echo '<div class="bordered" style="overflow:hidden;padding:4px;height:128px;"><div class=" video-container_master" style="max-width:100%;height:auto;overflow:hidden;">
							<div class="video-wrapper" style="overflow:hidden;">
								<div class="video-container" style="overflow:hidden;">
								 <div class="html5video" style="overflow:hidden; ">
														<iframe frameborder="4" width="100%" height="100%"  src="'.$template_uri_widgets.'/functions/video_shortcodes.php?mp4='.$videomp4.'&preview='.$preview.'" style="overflow:hidden !important;" bgcolor="#C9D3DE"></iframe>
													
													</div>
	
		</div></div></div></div>
			';
	
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['videomp4'] = $new_instance['videomp4'];
		$instance['videowebm'] = $new_instance['videowebm'];
		$instance['preview'] = $new_instance['preview'];
		return $instance;
	}
}
//add_action( 'widgets_init', create_function('', 'return register_widget("alteregoSidebarhtml5");') );




/* ------------------------------------- */
/* alterego POSTS WIDGET */
/* ------------------------------------- */


class alteregoPosts extends WP_Widget {

	function alteregoPosts() {
		$widget_ops = array('classname' => 'alteregoPosts', 'description' => 'A popular/latest posts widget.');
    	$this->WP_Widget('alteregoPosts', 'alterego Popular/Latest Posts', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>

		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>

        <p><label for="<?php echo $this->get_field_id( 'postcount' ); ?>">Post Count:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'postcount' ); ?>" name="<?php echo $this->get_field_name( 'postcount' ); ?>" value="<?php if( isset($instance['postcount']) ) echo $instance['postcount']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'poplatest' ); ?>">Latest or Popular:</label><br />
        <select class="widefat" id="<?php echo $this->get_field_id( 'poplatest' ); ?>" name="<?php echo $this->get_field_name( 'poplatest' ); ?>">
        	<option value="1" <?php 
        		if( isset($instance['poplatest']) && $instance['poplatest']== 1 ) {
        			echo "selected"; 
        		}
        	?>>Latest Posts</option>
        	<option value="2" <?php 
        		if( isset($instance['poplatest']) && $instance['poplatest']== 2 ) {
        			echo "selected"; 
        		}
        	?>>Popular Posts</option>
        </select>
        </p>
        
        <p><label for="<?php echo $this->get_field_id( 'posttype' ); ?>">Show this Category Slug:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'posttype' ); ?>" name="<?php echo $this->get_field_name( 'posttype' ); ?>" value="<?php if( isset($instance['posttype']) ) echo $instance['posttype']; ?>" /></p>
        <!--
        <p><label for="<?php echo $this->get_field_id( 'timeformat' ); ?>">Time Format (see <a href="http://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">here</a>):</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'timeformat' ); ?>" name="<?php echo $this->get_field_name( 'timeformat' ); ?>" value="<?php if( isset($instance['timeformat']) ) echo $instance['timeformat']; ?>" /></p>
        -->
        
	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$pcount = $instance['postcount'];
		$platest = $instance['poplatest'];
		$ptype = $instance['posttype'];
		$tformat = $instance['timeformat'];
		$rmore = $instance['readmore'];
		
		$alterego_teaser_readmore = __('Read More', 'alterego');

		echo $before_widget;
		
	   	if ( $title ) echo $before_title . $title . $after_title;
		
		if($ptype==""){
			$ptype = 'post';
		}

		$category = get_category_by_slug($ptype);
		if($category)$catid = $category->term_id;
		else $catid="";

		if($platest==1){
			$popargs = array( 'numberposts' => $pcount, 'orderby' => 'post_date', 'cat' => $catid );
		}else{
			$popargs = array( 'numberposts' => $pcount, 'orderby' => 'comment_count', 'cat' => $catid );
		}
		$unique = uniqid();
		$poplist = get_posts( $popargs );
		$popcount=1;
					echo '				<div class="widgetrotator">
											<div class="widget_navigation rightfloat">								
												<a href="#"><div class="widget_left"></div></a>
												<a href="#"><div class="widget_right"></div></a>
												<div class="clear"></div>
											</div>	
											
											<ul>';
		foreach ($poplist as $poppost) :  setup_postdata($poppost);
           	    $category = get_the_category($poppost->ID);
           	    if(isset($category[0]))
					$first_category = $category[0]->cat_name;
				else
					$first_category = "uncatagorized";
				$repl = strtolower((preg_replace('/\s+/', '-', $first_category)));
				$base = home_url();

				if(strlen($poppost->post_title)>18)
					$posttitle = substr($poppost->post_title, 0, 18)."...";
				else
					$posttitle = $poppost->post_title;
                
                if($popcount == sizeof($poplist)) $last=" style='margin-bottom:7px;'";
                else $last="";

				$blogimageurl = wp_get_attachment_url( get_post_thumbnail_id($poppost->ID) ); 
                if ($blogimageurl != "") {
                	echo '<li class="popularitem"><div class="mediaholder"><div class="fullcover"></div>
											<div class="viewproject"><a href="'.$base.'/'.$repl.'/'.$poppost->post_name.'"><div class="plusicon"></div></a></div><img class="" src="'.aq_resize($blogimageurl,65,65,true).'"></div>
													<div class="popularinfo">
														<a class="posttitle" href="'.$base.'/'.$repl.'/'.$poppost->post_name.'">'.$posttitle.'</a>
														<p class="postdate">'.date_i18n(get_option('date_format'), strtotime($poppost->post_date_gmt)).'</p>
														<a class="post_readmore" href="'.$base.'/'.$repl.'/'.$poppost->post_name.'">'.$alterego_teaser_readmore.'</a>
													</div>								
												</li>';
				}
				else{	
					echo '<li class="popularitem">
													<div class="popularinfo">
														<p><a class="posttitle" href="'.$base.'/'.$repl.'/'.$poppost->post_name.'">'.$posttitle.'</a></p>
														<p class="postdate">'.date_i18n(get_option('date_format'), strtotime($poppost->post_date_gmt)).'</p>
														<a class="post_readmore" href="'.$base.'/'.$repl.'/'.$poppost->post_name.'">'.$alterego_teaser_readmore.'</a>
													</div>								
												</li>';
				}
				$popcount++;
      endforeach;
      	echo '</ul>
								</div>';

		echo $after_widget;
	}


	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['postcount'] = $new_instance['postcount'];
		$instance['poplatest'] = $new_instance['poplatest'];
		$instance['posttype'] = $new_instance['posttype'];
		$instance['timeformat'] = $new_instance['timeformat'];
		$instance['readmore'] = $new_instance['readmore'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoPosts");') );


/* ------------------------------------- */
/* alterego TWITTER FEED WIDGET */
/* ------------------------------------- */


class alteregoTwitterfeed extends WP_Widget {

	function alteregoTwitterfeed() {
		$widget_ops = array('classname' => 'alteregoTwitterfeed', 'description' => 'Twitter Feed Widget');
    	$this->WP_Widget('alteregoTwitterfeed', 'alterego Twitter Feed', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'username' ); ?>">Twitter User Name:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php if( isset($instance['username']) ) echo $instance['username']; ?>" /></p> 
        
        <p><label for="<?php echo $this->get_field_id( 'feedcount' ); ?>">Feed Count:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'feedcount' ); ?>" name="<?php echo $this->get_field_name( 'feedcount' ); ?>" value="<?php if( isset($instance['feedcount']) ) echo $instance['feedcount']; ?>" /></p> 
        
	<?php
	}

	function widget( $args, $instance ) {
			extract( $args );
	
			$title = apply_filters('widget_title', $instance['title'] );
			if ( isset($instance['id']) ) $id = $instance['id'];
			$user = $instance['username'];
			$feeds = $instance['feedcount'];
			$uniqid = uniqid("tw_");
			echo $before_widget;
			
		   	if ( $title ) echo $before_title . $title . $after_title;
			echo '			<div class="tp_twitter_navigation rightfloat">
									<div class="tp_twitter_left"></div>
									<div class="tp_twitter_right"></div>
									<div class="clear"></div>
								</div>		
							<div class="twitter_container">													
								<div id="twitter_feed_'.$uniqid.'"></div>
								
							</div>
							<div class="divide25"></div>';
			echo '<script>
				jQuery("document").ready(function(){
					//////////////////
					// INIT TWITTER //
					//////////////////
						jQuery("#twitter_feed_'.$uniqid.'").twitterReader({
							user:"'.$user.'",
							count:'.$feeds.'
						});	 
				});
			</script>';
			echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['username'] = $new_instance['username'];
		$instance['feedcount'] = $new_instance['feedcount'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoTwitterfeed");') );



/* ------------------------------------- */
/* alterego CONTACT FEED WIDGET */
/* ------------------------------------- */


class alteregoContactInfo extends WP_Widget {

	function alteregoContactInfo() {
		$widget_ops = array('classname' => 'alteregoContactInfo', 'description' => 'Address Info Widget');
    	$this->WP_Widget('alteregoContactInfo', 'alterego Address Info', $widget_ops);
	}
	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance ); ?>
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( isset($instance['title']) ) echo $instance['title']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'address' ); ?>">Address:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" value="<?php if( isset($instance['address']) ) echo $instance['address']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'fon' ); ?>">Fon:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'fon' ); ?>" name="<?php echo $this->get_field_name( 'fon' ); ?>" value="<?php if( isset($instance['fon']) ) echo $instance['fon']; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id( 'fax' ); ?>">Fax:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" value="<?php if( isset($instance['fax']) ) echo $instance['fax']; ?>" /></p>
         <p><label for="<?php echo $this->get_field_id( 'mail' ); ?>">Mail:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'mail' ); ?>" name="<?php echo $this->get_field_name( 'mail' ); ?>" value="<?php if( isset($instance['mail']) ) echo $instance['mail']; ?>" /></p>
         <p><label for="<?php echo $this->get_field_id( 'info' ); ?>">Info:</label><br /><input class="widefat" id="<?php echo $this->get_field_id( 'info' ); ?>" name="<?php echo $this->get_field_name( 'info' ); ?>" value="<?php if( isset($instance['info']) ) echo $instance['info']; ?>" /></p>

 	<?php
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		if ( isset($instance['id']) ) $id = $instance['id'];
		$address = $instance['address'];
		$fon = $instance['fon'];
		$fax = $instance['fax'];
		$mail = $instance['mail'];
		$info = $instance['info'];
		
		echo $before_widget;
	   	if ( $title ) echo $before_title . $title . $after_title;
		
		if($fax!="")$fon = $fon."<br>Fax: ".$fax;
		
		echo '<p class="fh-pin">'.$address.'</p>
			  <p class="fh-phone">Phone: '.$fon.'</p>	
			  <p class="fh-pen">Email: <a mailto="'.$mail.'">'.$mail.'</a></p>
			  <p class="contact_info">'.$info.'</p>';
		
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['address'] = $new_instance['address'];
		$instance['mail'] = $new_instance['mail'];
		$instance['fon'] = $new_instance['fon'];
		$instance['fax'] = $new_instance['fax'];
		$instance['info'] = $new_instance['info'];
		return $instance;
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("alteregoContactInfo");') );




?>